/*
 * Cache.cpp
 *
 *  Created on: 29.04.2010
 *      Author: stefan.detter
 */

#include "Cache.h"

#include <QCoreApplication>
#include <QSettings>

#include <def.h>

Cache Cache::d;

Cache::Cache()
{
	m_settings = new QSettings(QSettings::IniFormat, QSettings::UserScope, COMPANY_NAME, ".Reader Suite Cache");
	m_cache = m_settings->value("Cache", QMap<QString, QVariant>()).toMap();
}

Cache::~Cache()
{
	m_settings->setValue("Cache", m_cache);
	delete m_settings;
}

QVariant Cache::value(QString key, const QVariant& defaultValue)
{
	if(m_cache.contains(key))
		return m_cache.value(key);
	return defaultValue;
}

void Cache::setValue(QString key, const QVariant& value)
{
	m_cache.insert(key, value);
	m_settings->setValue("Cache", m_cache);
}

